import itertools
from math import atan2

def point_in_polygon(point, polygon):
    num_vertices = len(polygon)
    x, y = point[0], point[1]
    inside = False
 
    p1 = polygon[0]
 
    for i in range(1, num_vertices + 1):
        p2 = polygon[i % num_vertices]
 
        if y > min(p1[1], p2[1]):
            if y <= max(p1[1], p2[1]):
                if x <= max(p1[0], p2[0]):
                    x_intersection = (y - p1[1]) * (p2[0] - p1[0]) / (p2[1] - p1[1]) + p1[0]
 
                    if p1[0] == p2[0] or x <= x_intersection:
                        inside = not inside
 
        p1 = p2
 
    return inside


def argsort(seq):
    return sorted(range(len(seq)), key=seq.__getitem__)

def rotational_sort(list_of_xy_coords, centre_of_rotation_xy_coord, clockwise=False):
    cx,cy=centre_of_rotation_xy_coord
    angles = [atan2(x-cx, y-cy) for x,y in list_of_xy_coords]
    indices = argsort(angles)
    if clockwise:
        return [list_of_xy_coords[i] for i in indices]
    else:
        return [list_of_xy_coords[i] for i in indices[::-1]]


class Polygon:
    def __init__(self, points):
        self.points = rotational_sort(points, (sum(elt[0] for elt in points)/len(points), sum(elt[1] for elt in points)/len(points)))
        

        self.area = abs(self.calculate_area(self.points))

    def calculate_area(self, points):
        n = len(points)
        area = 0.0
        for i in range(n):
            j = (i + 1) % n
            area += points[i][0] * points[j][1]
            area -= points[j][0] * points[i][1]
        return 0.5 * area



points = []

for _ in range(int(input().strip())):
    crds = [int(x) for x in input().strip().split(' ')]
    
    points.append((crds[0], crds[1]))

polygons = []

for r in range(3, len(points)):
    for i in itertools.combinations(points, r):
        polygons.append(Polygon(list(i)))

#print(polygons)
areas = []

for polygon in polygons:
    num = 0

    for point in points:
        #print(point)
        if point_in_polygon(point, polygon.points) or point in polygon.points:
            num += 1

    if num == len(points) - 1:
        areas.append(int(polygon.area))
        #print(polygon.points)

#print(areas)
print(min(areas))